//Removal of Noise from the combination of sinusoidal Signal plus noise
//Noise removal is facilitated using the cross correlation of signal plus Noise and an impulse train
//Windows 10
//Scilab 6.1.0
clear
clc
//Generation of signal  plus Noise
f=input('Enter the frequency of the signal:')
T=1/f;
t=0:T/f:T;
x=sin(2*%pi*f*t);
x1=x;
//generation of random  noise
rand('normal')
N=rand(1,length(t));
//signal+Noise
y=x+N;
h=flipdim(y,2);
//Finding the Period/length of a sinusoidal signal, mixed with Noise
[m,n]=max(conv(y,h));
l=length(x);
c=input('Enter the number of cycles:')
I=eye(l,l);
I1=I;
for i=1:c-1
    x=[x x1]
    I=[I I1]
end
rand('normal')
q=rand(1,length(x))
p=x+q;
for i=1:l
    y(i)=sum(p.*I(i,:));
end
//The position of the maximum value of Autocorrelation will be the length of the sequence
disp('The length of the signal is',n)
subplot(3,1,1)
xset("thickness",3)
plot2d(t,x1,rect=[0 min(x1)-1 T max(x1)])
xtitle("x(t)","Time","Amplitude")
legend("sinusoidal signal of frequency 10 Hz")
subplot(3,1,2)
xset("thickness",3)
plot2d(t,p(1:length(x1)),rect=[0 min(p)-0.5 T max(p)])
xtitle("x(t)+n(t)","Time","Amplitude")
legend("Signal plus noise")
subplot(3,1,3)
xset("thickness",3)
plot2d(t,y,rect=[0 min(y)-0.5 T max(y)])
xtitle("Estmated x(t)","Time","Amplitude")
legend("Estimated sinusoidal signal")


//output test case
//frequency of the signal:10
//number of cycles:10
//The length of the signal is :11.
 
//output test case 
//frequency of the signal:10
//number of cycles:750
//The length of the signal :11

//About the result
//The rand function generates dissimilar data in each run of the code
//Hence, Result will vary from run to run of the code
